<?php 
/**
 * Attendance Main Page
 */
$page_title = "Attendance";
require_once __DIR__ . '/../includes/header.php'; 
$flash = SessionHelper::getFlash('attendance_msg');
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="bi bi-calendar-check"></i> Student Attendance</h2>
    <div>
        <a href="/sms/public/attendance/take" class="btn btn-primary">
            <i class="bi bi-pencil"></i> Take Attendance
        </a>
        <a href="/sms/public/attendance/report" class="btn btn-info text-white">
            <i class="bi bi-file-earmark-bar-graph"></i> Reports
        </a>
    </div>
</div>

<?php if ($flash): ?>
    <div class="alert alert-<?= $flash['type'] ?> alert-dismissible fade show" role="alert">
        <?= $flash['message'] ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<div class="row">
    <div class="col-md-6 mb-4">
        <div class="card shadow h-100">
            <div class="card-header bg-primary text-white">
                <h5 class="mb-0"><i class="bi bi-pencil"></i> Take Attendance</h5>
            </div>
            <div class="card-body">
                <p class="text-muted">Record daily attendance for a class</p>
                <form method="GET" action="/sms/public/attendance/take" class="row g-3">
                    <div class="col-12">
                        <label>Select Class</label>
                        <select name="class" class="form-select" required>
                            <option value="">-- Select Class --</option>
                            <?php foreach ($classes as $class): ?>
                                <option value="<?= $class['id'] ?>"><?= $class['name'] ?> - <?= $class['section'] ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="col-12">
                        <label>Date</label>
                        <input type="date" name="date" class="form-control" value="<?= date('Y-m-d') ?>" required>
                    </div>
                    <div class="col-12">
                        <button type="submit" class="btn btn-primary w-100">Go to Attendance Sheet</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <div class="col-md-6 mb-4">
        <div class="card shadow h-100">
            <div class="card-header bg-info text-white">
                <h5 class="mb-0"><i class="bi bi-file-earmark-bar-graph"></i> View Reports</h5>
            </div>
            <div class="card-body">
                <p class="text-muted">Generate attendance reports for students</p>
                <a href="/sms/public/attendance/report" class="btn btn-info text-white w-100">
                    <i class="bi bi-arrow-right"></i> Go to Reports
                </a>
            </div>
        </div>
    </div>
</div>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>