<?php 
/**
 * Class Attendance Report
 */
$page_title = "Class Attendance Report";
require_once __DIR__ . '/../includes/header.php'; 
?>

<h2><i class="bi bi-people"></i> Class Attendance Report</h2>

<form method="GET" class="card p-4 mb-4">
    <div class="row">
        <div class="col-md-4 mb-3">
            <label>Select Class</label>
            <select name="class" class="form-select" required>
                <option value="">-- Select Class --</option>
                <?php foreach ($classes as $class): ?>
                    <option value="<?= $class['id'] ?>" <?= ($class_id ?? '') == $class['id'] ? 'selected' : '' ?>>
                        <?= $class['name'] ?> - <?= $class['section'] ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="col-md-4 mb-3">
            <label>Date</label>
            <input type="date" name="date" class="form-control" value="<?= $date ?? date('Y-m-d') ?>">
        </div>
        <div class="col-md-4 mb-3 d-flex align-items-end">
            <button type="submit" class="btn btn-primary w-100">View Report</button>
        </div>
    </div>
</form>

<?php if ($summary): ?>
<div class="row mb-4">
    <div class="col-md-3">
        <div class="card bg-primary text-white">
            <div class="card-body text-center">
                <h3><?= $summary['total_students'] ?></h3>
                <p>Total Students</p>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card bg-success text-white">
            <div class="card-body text-center">
                <h3><?= $summary['present'] ?></h3>
                <p>Present</p>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card bg-danger text-white">
            <div class="card-body text-center">
                <h3><?= $summary['absent'] ?></h3>
                <p>Absent</p>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card bg-warning text-white">
            <div class="card-body text-center">
                <h3><?= $summary['late'] + $summary['excused'] ?></h3>
                <p>Late/Excused</p>
            </div>
        </div>
    </div>
</div>
<?php endif; ?>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>