<?php
/**
 * Subject Model
 * Handles all subject-related database operations
 */
require_once __DIR__ . '/../../core/Database.php';

class SubjectModel {
    private $db;

    public function __construct() {
        $this->db = Database::getInstance()->getConnection();
    }

    public function getAll() {
        $stmt = $this->db->query("SELECT * FROM subjects ORDER BY name ASC");
        return $stmt->fetchAll();
    }

    public function getById($id) {
        $stmt = $this->db->prepare("SELECT * FROM subjects WHERE id = ?");
        $stmt->execute([$id]);
        return $stmt->fetch();
    }

    public function getByCode($code) {
        $stmt = $this->db->prepare("SELECT * FROM subjects WHERE code = ?");
        $stmt->execute([$code]);
        return $stmt->fetch();
    }

    public function create($name, $code) {
        $stmt = $this->db->prepare("INSERT INTO subjects (name, code) VALUES (?, ?)");
        return $stmt->execute([$name, $code]);
    }

    public function update($id, $name, $code) {
        $stmt = $this->db->prepare("UPDATE subjects SET name=?, code=? WHERE id=?");
        return $stmt->execute([$name, $code, $id]);
    }

    public function delete($id) {
        $stmt = $this->db->prepare("DELETE FROM subjects WHERE id = ?");
        return $stmt->execute([$id]);
    }

    public function assignToClass($class_id, $subject_id) {
        $stmt = $this->db->prepare("INSERT INTO class_subjects (class_id, subject_id) VALUES (?, ?)");
        return $stmt->execute([$class_id, $subject_id]);
    }

    public function removeFromClass($class_id, $subject_id) {
        $stmt = $this->db->prepare("DELETE FROM class_subjects WHERE class_id = ? AND subject_id = ?");
        return $stmt->execute([$class_id, $subject_id]);
    }

    public function getByClass($class_id) {
        $stmt = $this->db->prepare("SELECT s.* FROM subjects s 
                                    JOIN class_subjects cs ON s.id = cs.subject_id 
                                    WHERE cs.class_id = ?");
        $stmt->execute([$class_id]);
        return $stmt->fetchAll();
    }

    public function getClassCount($subject_id) {
        $stmt = $this->db->prepare("SELECT COUNT(*) FROM class_subjects WHERE subject_id = ?");
        $stmt->execute([$subject_id]);
        return $stmt->fetchColumn();
    }
}