<?php
/**
 * Validation Helper
 * Additional validation functions
 */
class ValidationHelper {
    /**
     * Validate phone number
     */
    public static function isPhone($phone) {
        return preg_match('/^[0-9+\-\s()]{10,20}$/', $phone);
    }
    
    /**
     * Validate ID number
     */
    public static function isIDNumber($id) {
        return preg_match('/^[A-Z0-9]{8,20}$/', $id);
    }
    
    /**
     * Sanitize input
     */
    public static function sanitize($data) {
        return htmlspecialchars(trim($data), ENT_QUOTES, 'UTF-8');
    }
    
    /**
     * Generate unique code
     */
    public static function generateCode($length = 10) {
        return strtoupper(substr(md5(uniqid()), 0, $length));
    }
    
    /**
     * Validate email
     */
    public static function isEmail($email) {
        return filter_var($email, FILTER_VALIDATE_EMAIL);
    }
    
    /**
     * Validate URL
     */
    public static function isURL($url) {
        return filter_var($url, FILTER_VALIDATE_URL);
    }
    
    /**
     * Check if value is numeric
     */
    public static function isNumeric($value) {
        return is_numeric($value);
    }
    
    /**
     * Validate date format
     */
    public static function isDate($date, $format = 'Y-m-d') {
        $d = DateTime::createFromFormat($format, $date);
        return $d && $d->format($format) === $date;
    }
    
    /**
     * Generate admission number
     */
    public static function generateAdmissionNumber($prefix = 'ADM') {
        return $prefix . '-' . date('Y') . '-' . str_pad(rand(1, 9999), 4, '0', STR_PAD_LEFT);
    }
    
    /**
     * Generate invoice number
     */
    public static function generateInvoiceNumber($prefix = 'INV') {
        return $prefix . '-' . date('Y') . '-' . str_pad(rand(1000, 9999), 4, '0', STR_PAD_LEFT);
    }
}