<?php
/**
 * Date Helper
 * Handles date formatting and calculations
 */
class DateHelper {
    /**
     * Format date
     */
    public static function formatDate($date, $format = 'M d, Y') {
        if (!$date) return '-';
        return date($format, strtotime($date));
    }
    
    /**
     * Format datetime
     */
    public static function formatDateTime($datetime, $format = 'M d, Y h:i A') {
        if (!$datetime) return '-';
        return date($format, strtotime($datetime));
    }
    
    /**
     * Calculate age from birthdate
     */
    public static function getAge($birthdate) {
        if (!$birthdate) return 0;
        $birth = new DateTime($birthdate);
        $today = new DateTime();
        $diff = $today->diff($birth);
        return $diff->y;
    }
    
    /**
     * Calculate days between two dates
     */
    public static function daysBetween($date1, $date2) {
        $d1 = new DateTime($date1);
        $d2 = new DateTime($date2);
        $diff = $d1->diff($d2);
        return $diff->days;
    }
    
    /**
     * Check if date is overdue
     */
    public static function isOverdue($due_date) {
        if (!$due_date) return false;
        return strtotime($due_date) < time();
    }
    
    /**
     * Get days overdue
     */
    public static function daysOverdue($due_date) {
        if (!$due_date) return 0;
        $due = new DateTime($due_date);
        $today = new DateTime();
        $diff = $today->diff($due);
        return $due < $today ? $diff->days : 0;
    }
    
    /**
     * Add days to date
     */
    public static function addDays($date, $days) {
        $d = new DateTime($date);
        $d->modify("+{$days} days");
        return $d->format('Y-m-d');
    }
    
    /**
     * Get current academic year
     */
    public static function getCurrentAcademicYear() {
        $year = date('Y');
        $month = date('n');
        if ($month >= 9) {
            return $year . '-' . ($year + 1);
        }
        return ($year - 1) . '-' . $year;
    }
}