<?php
require_once __DIR__ . '/../../core/Auth.php';
require_once __DIR__ . '/../../core/Controller.php';
require_once __DIR__ . '/../../app/models/UserModel.php';
require_once __DIR__ . '/../../app/helpers/SessionHelper.php';

class UserController extends Controller {
    private $model;

    public function __construct() {
        Auth::checkRole(['Super Admin', 'Admin']);
        $this->model = new UserModel();
    }

    public function index() {
        $users = $this->model->getAll();
        require_once __DIR__ . '/../views/users/index.php';
    }

    public function create() {
        $roles = $this->model->getRoles();
        require_once __DIR__ . '/../views/users/create.php';
    }

    public function store() {
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            Auth::validateCsrf($_POST['csrf_token']);
            
            $errors = $this->validate($_POST, [
                'username' => 'required|min:3|max:50',
                'email' => 'required|email',
                'password' => 'required|min:6',
                'full_name' => 'required|max:100'
            ]);

            if (!empty($errors)) {
                SessionHelper::setFlash('user_errors', $errors);
                header("Location: /sms/public/user/create");
                exit;
            }

            if ($this->model->create($_POST)) {
                SessionHelper::setFlash('user_msg', 'User created successfully!', 'success');
            } else {
                SessionHelper::setFlash('user_msg', 'Failed to create user.', 'danger');
            }
            header("Location: /sms/public/user/index");
            exit;
        }
    }

    public function edit($id) {
        $user = $this->model->getById($id);
        $roles = $this->model->getRoles();
        if (!$user) die("User not found");
        require_once __DIR__ . '/../views/users/edit.php';
    }

    public function update($id) {
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            Auth::validateCsrf($_POST['csrf_token']);
            
            if ($this->model->update($id, $_POST)) {
                SessionHelper::setFlash('user_msg', 'User updated successfully!', 'success');
            } else {
                SessionHelper::setFlash('user_msg', 'Failed to update user.', 'danger');
            }
            header("Location: /sms/public/user/index");
            exit;
        }
    }

    public function delete($id) {
        if ($this->model->delete($id)) {
            SessionHelper::setFlash('user_msg', 'User deleted successfully!', 'success');
        } else {
            SessionHelper::setFlash('user_msg', 'Failed to delete user.', 'danger');
        }
        header("Location: /sms/public/user/index");
        exit;
    }

    public function toggleStatus($id) {
        $user = $this->model->getById($id);
        if ($user['is_active']) {
            $this->model->deactivate($id);
        } else {
            $this->model->activate($id);
        }
        header("Location: /sms/public/user/index");
        exit;
    }
}