<?php
/**
 * Subject Controller
 * Handles all subject-related operations
 */
require_once __DIR__ . '/../../core/Auth.php';
require_once __DIR__ . '/../../core/Controller.php';
require_once __DIR__ . '/../../app/models/SubjectModel.php';
require_once __DIR__ . '/../../app/helpers/SessionHelper.php';

class SubjectController extends Controller {
    private $model;

    public function __construct() {
        Auth::checkRole(['Super Admin', 'Admin', 'Teacher']);
        $this->model = new SubjectModel();
    }

    public function index() {
        $subjects = $this->model->getAll();
        require_once __DIR__ . '/../views/subjects/index.php';
    }

    public function create() {
        require_once __DIR__ . '/../views/subjects/create.php';
    }

    public function store() {
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            Auth::validateCsrf($_POST['csrf_token']);
            
            $errors = $this->validate($_POST, [
                'name' => 'required|max:100',
                'code' => 'required|max:20'
            ]);

            if (!empty($errors)) {
                SessionHelper::setFlash('subject_errors', $errors);
                header("Location: /sms/public/subject/create");
                exit;
            }

            // Check if code already exists
            if ($this->model->getByCode($_POST['code'])) {
                SessionHelper::setFlash('subject_msg', 'Subject code already exists.', 'danger');
                header("Location: /sms/public/subject/create");
                exit;
            }

            if ($this->model->create($_POST['name'], $_POST['code'])) {
                SessionHelper::setFlash('subject_msg', 'Subject created successfully!', 'success');
            } else {
                SessionHelper::setFlash('subject_msg', 'Failed to create subject.', 'danger');
            }
            header("Location: /sms/public/subject/index");
            exit;
        }
    }

    public function edit($id) {
        $subject = $this->model->getById($id);
        if (!$subject) {
            SessionHelper::setFlash('subject_msg', 'Subject not found.', 'danger');
            header("Location: /sms/public/subject/index");
            exit;
        }
        require_once __DIR__ . '/../views/subjects/edit.php';
    }

    public function update($id) {
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            Auth::validateCsrf($_POST['csrf_token']);
            
            $errors = $this->validate($_POST, [
                'name' => 'required|max:100',
                'code' => 'required|max:20'
            ]);

            if (!empty($errors)) {
                SessionHelper::setFlash('subject_errors', $errors);
                header("Location: /sms/public/subject/edit/" . $id);
                exit;
            }

            if ($this->model->update($id, $_POST['name'], $_POST['code'])) {
                SessionHelper::setFlash('subject_msg', 'Subject updated successfully!', 'success');
            } else {
                SessionHelper::setFlash('subject_msg', 'Failed to update subject.', 'danger');
            }
            header("Location: /sms/public/subject/index");
            exit;
        }
    }

    public function delete($id) {
        if ($this->model->delete($id)) {
            SessionHelper::setFlash('subject_msg', 'Subject deleted successfully!', 'success');
        } else {
            SessionHelper::setFlash('subject_msg', 'Failed to delete subject.', 'danger');
        }
        header("Location: /sms/public/subject/index");
        exit;
    }
}