<?php
require_once __DIR__ . '/../../core/Auth.php';
require_once __DIR__ . '/../../app/models/StudentModel.php';
require_once __DIR__ . '/../../app/helpers/SessionHelper.php';

class StudentController {
    private $model;

    public function __construct() {
        // Only Admin, Super Admin, and Teachers can manage students
        Auth::checkRole(['Super Admin', 'Admin', 'Teacher']);
        $this->model = new StudentModel();
    }

    public function index() {
        $students = $this->model->getAll();
        $flash = SessionHelper::getFlash('student_msg');
        require_once __DIR__ . '/../views/students/index.php';
    }

    public function create() {
        $classes = $this->model->getClasses();
        require_once __DIR__ . '/../views/students/create.php';
    }

    public function store() {
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            Auth::validateCsrf($_POST['csrf_token']);

            // Simple Validation
            $admission_no = filter_input(INPUT_POST, 'admission_no', FILTER_SANITIZE_SPECIAL_CHARS);
            $first_name = filter_input(INPUT_POST, 'first_name', FILTER_SANITIZE_SPECIAL_CHARS);
            
            // Create Parent First (Simplified Logic)
            $parent_id = $this->model->createParent([
                'father_name' => $_POST['father_name'],
                'mother_name' => $_POST['mother_name'],
                'phone' => $_POST['phone'],
                'email' => $_POST['email'],
                'address' => $_POST['address']
            ]);

            $data = [
                'admission_no' => $admission_no,
                'first_name' => $first_name,
                'last_name' => $_POST['last_name'],
                'gender' => $_POST['gender'],
                'dob' => $_POST['dob'],
                'class_id' => $_POST['class_id'],
                'parent_id' => $parent_id
            ];

            if ($this->model->create($data)) {
                SessionHelper::setFlash('student_msg', 'Student added successfully!', 'success');
            } else {
                SessionHelper::setFlash('student_msg', 'Failed to add student.', 'danger');
            }
            header("Location: /sms/public/student/index");
            exit;
        }
    }

    public function edit($id) {
        $student = $this->model->getById($id);
        $classes = $this->model->getClasses();
        if (!$student) die("Student not found");
        require_once __DIR__ . '/../views/students/edit.php';
    }

    public function update($id) {
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            Auth::validateCsrf($_POST['csrf_token']);
            
            $data = [
                'first_name' => $_POST['first_name'],
                'last_name' => $_POST['last_name'],
                'gender' => $_POST['gender'],
                'dob' => $_POST['dob'],
                'class_id' => $_POST['class_id'],
                'parent_id' => $_POST['parent_id'] // In real app, update parent details separately
            ];

            if ($this->model->update($id, $data)) {
                SessionHelper::setFlash('student_msg', 'Student updated successfully!', 'success');
            } else {
                SessionHelper::setFlash('student_msg', 'Failed to update student.', 'danger');
            }
            header("Location: /sms/public/student/index");
            exit;
        }
    }

    public function delete($id) {
        if ($this->model->delete($id)) {
            SessionHelper::setFlash('student_msg', 'Student deleted successfully!', 'success');
        } else {
            SessionHelper::setFlash('student_msg', 'Failed to delete student.', 'danger');
        }
        header("Location: /sms/public/student/index");
        exit;
    }
}