<?php
require_once __DIR__ . '/../../core/Auth.php';
require_once __DIR__ . '/../../app/models/MessageModel.php';
require_once __DIR__ . '/../../app/helpers/SessionHelper.php';

class MessageController {
    private $model;

    public function __construct() {
        Auth::checkRole(['Super Admin', 'Admin', 'Teacher', 'Student', 'Parent', 'Accountant']);
        $this->model = new MessageModel();
    }

    public function inbox() {
        $user = Auth::user();
        $messages = $this->model->getInbox($user['id']);
        require_once __DIR__ . '/../views/messages/inbox.php';
    }

    public function sent() {
        $user = Auth::user();
        $messages = $this->model->getSent($user['id']);
        require_once __DIR__ . '/../views/messages/sent.php';
    }

    public function compose() {
        $users = $this->model->getAllUsers();
        require_once __DIR__ . '/../views/messages/compose.php';
    }

    public function send() {
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            Auth::validateCsrf($_POST['csrf_token']);
            $user = Auth::user();
            
            if ($this->model->send($user['id'], $_POST['receiver_id'], $_POST['subject'], $_POST['message'])) {
                SessionHelper::setFlash('msg', 'Message sent!', 'success');
            } else {
                SessionHelper::setFlash('msg', 'Failed to send message.', 'danger');
            }
            header("Location: /sms/public/message/sent");
            exit;
        }
    }

    public function read($id) {
        $this->model->markAsRead($id);
        header("Location: /sms/public/message/inbox");
        exit;
    }
}