<?php
require_once __DIR__ . '/../../core/Database.php';
require_once __DIR__ . '/../../core/Auth.php';

class AuthController {
    private $db;

    public function __construct() {
        $this->db = Database::getInstance()->getConnection();
    }

    public function login() {
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            Auth::validateCsrf($_POST['csrf_token']);

            $username = filter_input(INPUT_POST, 'username', FILTER_SANITIZE_SPECIAL_CHARS);
            $password = $_POST['password'];

            $stmt = $this->db->prepare("SELECT u.*, r.name as role_name FROM users u JOIN roles r ON u.role_id = r.id WHERE u.username = ?");
            $stmt->execute([$username]);
            $user = $stmt->fetch();

            if ($user && password_verify($password, $user['password'])) {
                if ($user['is_active'] == 0) {
                    $error = "Account is deactivated.";
                } else {
                    Auth::login($user);
                    header("Location: /sms/public/dashboard");
                    exit;
                }
            } else {
                $error = "Invalid credentials.";
            }
        }

        require_once __DIR__ . '/../views/auth/login.php';
    }

    public function logout() {
        Auth::logout();
    }
}