<?php
/**
 * Attendance Controller
 * Handles all attendance-related operations
 */
require_once __DIR__ . '/../../core/Auth.php';
require_once __DIR__ . '/../../core/Controller.php';
require_once __DIR__ . '/../../app/models/AttendanceModel.php';
require_once __DIR__ . '/../../app/models/StudentModel.php';
require_once __DIR__ . '/../../app/helpers/SessionHelper.php';

class AttendanceController extends Controller {
    private $model;
    private $studentModel;

    public function __construct() {
        Auth::checkRole(['Super Admin', 'Admin', 'Teacher']);
        $this->model = new AttendanceModel();
        $this->studentModel = new StudentModel();
    }

    public function index() {
        $classes = $this->studentModel->getClasses();
        require_once __DIR__ . '/../views/attendance/index.php';
    }

    public function take() {
        $class_id = $_GET['class'] ?? null;
        $date = $_GET['date'] ?? date('Y-m-d');
        
        if (!$class_id) {
            $classes = $this->studentModel->getClasses();
            require_once __DIR__ . '/../views/attendance/select_class.php';
            return;
        }
        
        $students = $this->studentModel->getAll();
        $students = array_filter($students, fn($s) => $s['class_id'] == $class_id);
        $attendance = $this->model->getByClassAndDate($class_id, $date);
        
        require_once __DIR__ . '/../views/attendance/take.php';
    }

    public function store() {
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            Auth::validateCsrf($_POST['csrf_token']);
            
            $attendance_data = [];
            foreach ($_POST['student_id'] as $key => $student_id) {
                $attendance_data[] = [
                    'student_id' => $student_id,
                    'date' => $_POST['date'],
                    'status' => $_POST['status'][$key] ?? 'Present',
                    'remarks' => $_POST['remarks'][$key] ?? null
                ];
            }
            
            if ($this->model->bulkSave($attendance_data)) {
                SessionHelper::setFlash('attendance_msg', 'Attendance saved successfully!', 'success');
            } else {
                SessionHelper::setFlash('attendance_msg', 'Failed to save attendance.', 'danger');
            }
            
            header("Location: /sms/public/attendance/index");
            exit;
        }
    }

    public function report() {
        $students = $this->studentModel->getAll();
        $student_id = $_GET['student_id'] ?? null;
        $start_date = $_GET['start_date'] ?? null;
        $end_date = $_GET['end_date'] ?? null;
        
        $attendance_data = null;
        $attendance_rate = null;
        
        if ($student_id) {
            $attendance_data = $this->model->getByStudent($student_id, $start_date, $end_date);
            $attendance_rate = $this->model->getAttendanceRate($student_id);
        }
        
        require_once __DIR__ . '/../views/attendance/report.php';
    }

    public function classReport() {
        $class_id = $_GET['class'] ?? null;
        $date = $_GET['date'] ?? date('Y-m-d');
        
        $summary = null;
        if ($class_id) {
            $summary = $this->model->getClassAttendanceSummary($class_id, $date);
        }
        
        $classes = $this->studentModel->getClasses();
        require_once __DIR__ . '/../views/attendance/class_report.php';
    }
}